C	AXRLEC   (A. Le Bail)
C            is a program for tranforming powder data files
C            such as .dat obtained from the CVRAW program 
C            applied on Siemens .raw files.
C                The starting .dat must be :
C                        TITLE
C                        N of points
C                        2-theta starting angle
C                        Step in 2-theta
C                        Intensities, in free format
C                        .............
C
C                The output will be a .rit file in ARIT Format
C                TITLE
C                ...
C                N background points
C                estimated background for starting
C                2-theta-zero, step, 2-theta-end,        
C                Intensities                              as 10(I2,F6.0)
C   
C
      character*20 file,file2
      character*24 tmp
      logical qex
      DIMENSION Y(40000),TITLE(56),B(401),IA(401),Y2(40000),X1(40000)
C
      DEGRAD=3.14159265359/360.0
C
      IPR=20
      ILU=21
      IMP=22
	IPO=23
      print 3
    3 FORMAT('         AXRLEC   (by A. Le Bail)'/
     &'      is a program for tranforming powder data files'/
     &'      such as .dat obtained from the CVRAW program'/
     &'      applied on Siemens .raw files.'/
     &'         The starting .dat must be :'/
     &'                 TITLE'/
     &'                 N of points'/
     &'                 2-theta starting angle'/
     &'                 Step in 2-theta'/
     &'                 Intensities, in free format'/
     &'                                                   '/
     &'         The output will be a .out file in ARIT Format'/
     &'         Intensities                       as 10(I2,F6.0)')
      print 1
1     format('  entry .dat file (no extension) ??',$)
      read 2,file
2     format(A20)
4     format(A24)
      lfile=len(file)
      do while (file(lfile:lfile).eq.' ')
      lfile=lfile-1
      enddo
      tmp=file(1:lfile)//'.dat'
      call open_read1(ilu,tmp)
      tmp=file(1:lfile)//'.out'
      inquire(file=tmp,exist=qex)
      if(qex.eq..FALSE.) go to 10
      print *,'warning, this old file will be deleted :',tmp
      call filedel(ipr,tmp)
10    call open_write1(ipr,tmp)
      READ(ILU,5)(TITLE(I),I=1,56)
5     FORMAT(56A1)
      READ(ILU,*)NBMES
      READ(ILU,*)TH0
      READ(ILU,*)STP
      X1(1)=TH0
      DO 7604 I=2,NBMES
7604  X1(I)=X1(I-1)+STP
      THF=X1(NBMES)
      READ(ILU,*)(Y(I),I=1,NBMES)
      WRITE(IPR,5)(TITLE(I),I=1,56)
      PRINT 30
30    FORMAT('  Add a constant to the intensity (No=1, Yes=0)?',$)
      READ *,NADD
      IF(NADD.EQ.1)GO TO 2100
	PRINT 31
31    FORMAT('  Value of this constant ?',$)
      READ *,ADD
      DO 2050 I=1,NBMES
2050  Y(I)=Y(I)+ADD
2100  N=1
      PRINT 801
801   FORMAT('  SUBSTRACT A BACKGROUND FILE ? (YES=1, NO=0',$)
      READ *,NBAC  
      IF(NBAC.EQ.0)GO TO 804
      PRINT 803
803   FORMAT('  Scale factor for Y=Y-S*BACK ?',$)
      READ *,SCALE  
      close(ILU)
      print 1
      read 2,file2
      lfile2=len(file2)
      do while (file2(lfile2:lfile2).eq.' ')
      lfile2=lfile2-1
      enddo
      tmp=file2(1:lfile2)//'.dat'
      call open_read1(ilu,tmp)
      READ(ILU,5)(TITLE(I),I=1,56)
      READ(ILU,*)NBMES
      READ(ILU,*)TH0
      READ(ILU,*)STP
      READ(ILU,*)(Y2(I),I=1,NBMES)
      DO 802 I=1,NBMES
802   Y(I)=Y(I)-SCALE*Y2(I)
804 	PRINT 2001
2001  FORMAT('  CORRECTION FOR VARIABLE SLITS ? (YES=1, NO=0)',$)
      READ *,NSLIT
      IF(NSLIT.EQ.0)GO TO 2004
      DO 2002 I=1,NBMES
2002  Y(I)=Y(I)/SIN(X1(I)*DEGRAD)
2004  PRINT 805
805	FORMAT('  CORRECTION ALPHA 2 (YES=1,NO=0)',$)
	READ *,NALP
	IF(NALP.EQ.0)GO TO 810
	PRINT 806
806	FORMAT('  RA ET Cu(1),Co(2),Fe(3),Mo(4) ',$)
	READ *,RA,IL
	CALL STRIP2(Y,RA,IL,NBMES,TH0,STP)
810   YMAX=0.
      DO 2110 I=1,NBMES
2110  IF(Y(I).GT.YMAX)YMAX=Y(I)
      IF(YMAX.LE.9990000.)GO TO 2130
      DO 2120 I=1,NBMES
2120  Y(I)=Y(I)/YMAX*9990000.
2130  CONTINUE
C
C  Background estimation every 100 pts.
C
      B(1)=Y(1)
      IA(1)=(100.*TH0+0.5)
      NB=1
      DO 2140 I=1,NBMES,100
      NB=NB+1
      YMIN=9990000.
      DO 2135 J=I,I+99
2135  IF(Y(J).LT.YMIN)YMIN=Y(J)
      B(NB)=YMIN
      DO 2136 J=I,I+99
2136  IF(Y(J).EQ.B(NB))JJ=J
      IA(NB)=100.*(TH0+JJ*STP+0.5)
2140  CONTINUE
      WRITE(IPR,703)(NB-1)
      DO 2150 I=1,NB-1
      WRITE(IPR,705)IA(I),B(I)
2150  CONTINUE
705   FORMAT(I10,F8.0)
      II=0
      WRITE(IPR,705)II
      WRITE(IPR,705)II
C
      ITH0=(100.*TH0+0.5)
      ISTP=(100.*STP+0.5)
      ITHF=(100.*THF+0.5)
      WRITE(IPR,703)ITH0,ISTP,ITHF
703	FORMAT(3I10)
      DO 2300 I=1,NBMES,10
2300	WRITE(IPR,704)Y(I),Y(I+1),Y(I+2),Y(I+3),
     1Y(I+4),Y(I+5),Y(I+6),Y(I+7),Y(I+8),Y(I+9)
704	FORMAT(10F8.0)
      tmp=file(1:lfile)//'.rit'
      inquire(file=tmp,exist=qex)
      if(qex.eq..FALSE.) go to 300
      print *,'warning, this old file will be deleted :',tmp
      call filedel(imp,tmp)
300    call open_write1(imp,tmp)
      tmp=file(1:lfile)//'.pow'
      inquire(file=tmp,exist=qex)
      if(qex.eq..FALSE.) go to 301
      print *,'warning, this old file will be deleted :',tmp
      call filedel(imp,tmp)
301    call open_write1(ipo,tmp)
      WRITE(IMP,29)TH0,STP,THF,(TITLE(I),I=1,56)
29	FORMAT(3F8.3,1X,56A1)
	DO 32 I=1,NBMES,8
32	WRITE(IMP,33)Y(I),Y(I+1),Y(I+2),Y(I+3),Y(I+4),Y(I+5),
     1Y(I+6),Y(I+7)
33	FORMAT(8(F7.0,1X))
	DO 34 I=1,NBMES,10
34	WRITE(IPO,35)Y(I),Y(I+1),Y(I+2),Y(I+3),Y(I+4),Y(I+5),
     1Y(I+6),Y(I+7),Y(I+8),Y(I+9)
35	FORMAT(10F8.0)
      PRINT 6
   6  FORMAT('   Thanks for using AXRLEC'//
     &'   Please type any number and a return to stop')
      Read *,bid
      STOP
      END
	SUBROUTINE STRIP2(BUF,RA,IL,NBMES,TH0,STP)
      DIMENSION DLAM(4),BUF(40000)
	DATA PIF,DLAM/8.726646E-3,2.48484E-3,2.1716E-3,2.034E-3,1.71E-3/
	DTH=STP*PIF
	DLAM2=DLAM(IL)*.5
	IF(DTH.LE.0.)RETURN
	DO 10 J=1,NBMES
	TH=(TH0+(J-1)*STP)*PIF
	TG=SIN(TH)/COS(TH)
	DX=TG*DLAM(IL)*(1.+DLAM2*TG**2)/DTH
	INC=DX
	I=J+INC
	IF(I.GT.NBMES)RETURN
	REST=INC-DX+1.
	DY=BUF(J)*RA
	BUF(I)=AMAX1(0.,BUF(I)-DY*REST)
	IF(I.GE.NBMES)RETURN
	I=I+1
 10	BUF(I)=AMAX1(0.,BUF(I)-DY*(1.-REST))
	END
      subroutine open_read1(unit,file)
      integer unit
      character*(*) file
      open (unit,file=file,status='old')
      return
      end
      subroutine open_write1(unit,file)
      integer unit
      character*(*) file
      open (unit,file=file,status='new')
      return
      end
      subroutine filedel(unit,file)
      integer unit
      character*(*) file
      open (unit,file=file,status='old')
      close (unit,status='delete')
      return
      end
